#!/system/bin/sh
#2023-11-29

if [ -e "$basedir" ]; then
  preInstallDir=$basedir
else
  preInstallDir=/mnt/usb_storage/preInstall
  if [ ! -e $preInstallDir ]; then
    if [ "${USB_STORAGE}" == "" ]; then
      USB_STORAGE=/storage/$(ls /storage | grep ".*-.*")
    fi
    preInstallDir=${USB_STORAGE}/preInstall
  fi
fi

sdk=`getprop ro.build.version.sdk`
folder_preinstall="/system/preinstall"
build_user=`getprop ro.build.user`
if [ "$build_user" == "yming" ] && [ $sdk -ge 24 ]; then
    folder_preinstall="/system/preInstall"
fi
if [ "$build_user" == "sunshine" ] && [ $sdk -ge 31 ]; then
    folder_preinstall="/system/preInstall"
fi

#获取系统语言
if [ $sdk -lt 23 ]; then
  lang=`getprop persist.sys.language`
  if [ "$lang" == "" ]; then
    lang="zh"
  fi
  country=`getprop persist.sys.country`
  language=${lang}_${country}
  if [ "$country" == "" ]; then
    language=$lang
  fi
elif [ $sdk -eq 23 ]; then
  language=`getprop persist.sys.locale | busybox  sed 's/-/_/g'`
  if [ "$language" == "null" ] || [ "$language" == "" ]; then
    language=`getprop ro.product.locale | busybox  sed 's/-/_/g'`
  fi
elif [ $sdk -gt 23 ]; then
  language=`settings get system system_locales | busybox  sed 's/-/_/g'`
  if [ "$language" == "null" ] || [ "$language" == "" ]; then
    language=`getprop ro.product.locale | busybox  sed 's/-/_/g'`
  fi
fi

if [ "$language" == "zh" ]; then
    language="zh_CN"
fi

if [ $language == "zh_Hans_CN" ]; then
    language="zh_CN"
fi

str_copy="正在拷贝"
str_uninstall="正在卸载"
str_installing_treadmill_app="正在安装跑步机APP..."
str_installing_indoorbike_app="正在安装单车APP..."
str_installing_stairmachine_app="正在安装楼梯机APP..."
str_installing_rowing_app="正在安装划船机APP..."
str_installing_strengthtrainer_app="正在安装力量训练器APP"
str_change_setting="正在更改系统设置..."

str_installing_qqmusichd="正在安装QQ音乐HD..."
str_installing_iqiyi="正在安装爱奇艺..."
str_installing_dsj2="正在安装电视家2.0..."
str_installing_dsj3="正在安装电视家3.0..."
str_installing_qqbrowser="正在安装QQ浏览器..."
str_installing_newstop="正在安装今日头条..."
str_installing_lebo="正在安装乐播投屏..."
str_installing_baidu="正在安装手机百度..."

str_installing_spotify="正在安装Spotify..."
str_installing_facebook="正在安装Facebook..."
str_installing_twitter="正在安装Twitter..."
str_installing_primevideo="正在安装PrimeVideo..."
str_installing_chrome="正在安装Chrome..."
str_installing_youtube="正在安装Youtube..."
str_installing_netflix="正在安装Netflix..."
str_installing_netflix_v4="正在安装Netflix v4.16..."
str_installing_kx_cast="正在安装KX Cast..."

str_installing_google_play="正在安装Google Play服务..."
str_installing_new_gms="正在安装最新GMS..."
str_installing_new_googlestore="正在安装谷歌市场..."
str_installing_autoinstall="正在安装AutoInstall..."
str_installing_apk_installer="安装Apk安装管理器..."
str_installing_provision="安装Provision..."

str_installing_latin="正在安装Android键盘..."
str_installing_zhuying="正在安装谷歌注音输入法..."
str_installing_pinyin="正在安装谷歌拼音输入法..."
str_installing_korean_hangul="正在安装韩文输入法..."
str_installing_zhongyang_softkeyboard="正在安装中阳英文输入法..."

str_ready_reboot="操作完成，准备重启跑步机"
str_copy_media="拷贝音视频文件"

str_switch_latin="切换为Android键盘..."
str_switch_zhuyin="切换为注音输入法..."
str_switch_pinyin="切换为拼音输入法..."
str_switch_jp="切换为日文输入法..."

str_installing_music="正在安装music..."
str_uninstalling_cn_app="正在删除中文版应用..."
str_uninstalling_en_app="正在删除英文版应用..."

str_checking_google_play="正在检查Google Play服务..."
str_change_logo="更改开机logo"
str_not_exist="不存在"


if [ "$forceLang" == "EN" ]; then
    str_copy="copying "
    str_uninstall="uninstalling "
    str_installing_treadmill_app="installing treadmill APP..."
    str_installing_indoorbike_app="installing indoorbike APP..."
    str_installing_stairmachine_app="installing stairmachine APP..."
    str_installing_rowing_app="installing rowing APP..."
    str_installing_strengthtrainer_app="installing StrengthTrainer APP..."
    str_change_setting="changing system settings..."
    
    str_installing_qqmusichd="installing QQMusicHD..."
    str_installing_iqiyi="installing iqiyi..."
    str_installing_dsj2="installing dianshijia 2.0..."
    str_installing_dsj3="installing dianshijia 3.0..."
    str_installing_qqbrowser="installing QQ browser..."
    str_installing_newstop="installing NewsTop..."
    str_installing_lebo="installing LeBo..."
    str_installing_baidu="installing Baidu..."

    str_installing_spotify="installing Spotify..."
    str_installing_facebook="installing Facebook..."
    str_installing_twitter="installing Twitter..."
    str_installing_primevideo="installing PrimeVideo..."
    str_installing_chrome="installing Chrome..."
    str_installing_youtube="installing Youtube..."
    str_installing_netflix="installing Netflix..."
    str_installing_netflix_v4="installing Netflix v4.16..."
    str_installing_kx_cast="installing KX Cast..."
    
    str_installing_google_play="installing Google Play Service..."
    str_installing_new_gms="installing new GMS..."
    str_installing_new_googlestore="installing Google Store..."
    str_installing_autoinstall="installing AutoInstall..."
    str_installing_apk_installer="installing ApkInstaller..."
    str_installing_provision="installing Provision..."
    
    str_installing_latin="installing Android Keyboard..."
    str_installing_zhuying="installing Google Zhuyin inputmethod..."
    str_installing_pinyin="installing Google Pinyin inputmethod..."
    str_installing_korean_hangul="installing Korean inputmethod..."
    str_installing_zhongyang_softkeyboard="installing ZY soft keyboard..."
    
    str_copy_media="copying media files"
    str_ready_reboot="finish, ready to reboot"
    
    str_switch_latin="switch to Android keyboard..."
    str_switch_zhuyin="switch to Zhuyin..."
    str_switch_pinyin="switch to Pinyin..."
    str_switch_jp="switch to Japanese inputmethod..."

    str_installing_ready_reboot="finish, ready to reboot"
    str_installing_copy_media="copying Media Files..."
    
    str_installing_music="installing music..."
    str_uninstalling_cn_app="uninstalling Chinese App..."
    str_uninstalling_en_app="uninstalling English App..."
    
    str_checking_google_play="checking Google Play Service..."
    str_change_logo="change bootanimation"
    str_not_exist="not exist"
fi

#开启未知来源安装
if [ $sdk -gt 19 ]; then
  settings put secure install_non_market_apps 1
else
  settings put global install_non_market_apps 1
fi

settings put global package_verifier_enable 0
settings put global package_verifier_user_consent -1
settings put global upload_apk_enable 0
settings put global verifier_verify_adb_installs 0
settings put global assisted_gps_enabled 1
settings put secure location_providers_allowed "gps,network"

#禁止休眠
settings put system screen_off_timeout 2147483647

function mountSystem()
{
    mount -o rw,remount /system >/dev/null 2>&1
    mount -o rw,remount / >/dev/null 2>&1
}

function clearPreinstall()
{
  if [ "$folder_preinstall" == "/system/preInstall" ] && [ -e /system/preinstall ]; then
    rm -rf /system/preinstall
  fi
  if [ "$folder_preinstall" == "/system/preinstall" ]; then
    rm -rf /system/bin/preinstall.sh
  fi
  filelist=`busybox ls -1 -d $folder_preinstall/*`
  for file in $filelist; do
    if [ $sdk -le 19 ]; then
        if [ ! -f "$file" ]; then
            rm -rf "$file"
            continue
        fi
    else
        if [ -f "$file" ]; then
            rm -rf "$file"
            continue
        fi  
    fi
    
    if [[ "$file" != "$folder_preinstall/com."* ]] && [[ "$file" != "$folder_preinstall/cn."* ]]; then
      rm -rf "$file"
    fi
  done
}

function checkSpace()
{
  if [ ! -e $folder_preinstall ]; then 
    mkdir $folder_preinstall
    chmod 755 $folder_preinstall
  fi
  #busybox find /system/preinstall -type d | grep -v "/system/preinstall$" | grep -v "com." | busybox xargs rm -rf
  clearPreinstall
  local temp=`df -h /system 2>/dev/null | busybox tail -1 | busybox awk '{print $2}'`
  if [ $sdk -ge 28 ]; then
    temp=`df -h / | busybox tail -1 | busybox awk '{print $2}'`
  fi
  local unit=${temp:0-1}
  local len=${#temp}
  local systemDiskSize=${temp:0:$len-1}
  opt_canCopyApp=0
  opt_canCopyVideo=0
  [[ "$unit" == "G" ]] && [[ "$systemDiskSize" > "1.4" ]] && opt_canCopyVideo=1
  [[ "$unit" == "G" ]] && [[ "$sdk" == "22" ]] && [[ "$systemDiskSize" > "1.5" ]] && opt_canCopyApp=1
  #[[ "$unit" == "M" ]] && [[ "$systemDiskSize" > "1000.0" ]] && canCopyApp=1
  #[ "$canCopyVideo" == "1" ] && canCopyApp=1
  
  canCopyApp=$opt_canCopyApp
  canCopyVideo=$opt_canCopyVideo
  
  if [ -e "/data/app/netflix" ] && [ -e "$preInstallDir/3rd" ]; then
    pm uninstall com.tencent.mtt >/dev/null 2>&1
    pm uninstall com.tencent.qqmusicpad >/dev/null 2>&1
    pm uninstall com.ss.android.article.news >/dev/null 2>&1
    pm uninstall com.qiyi.video.pad >/dev/null 2>&1
    pm uninstall com.netflix.mediaclient >/dev/null 2>&1
    pm uninstall com.facebook.katana >/dev/null 2>&1
    pm uninstall com.amazon.avod.thirdpartyclient >/dev/null 2>&1
    
    rm -rf /data/app/AmazonVideo
    rm -rf /data/app/BrowserQQ
    rm -rf /data/app/Chrome
    rm -rf /data/app/MusicQQ
    rm -rf /data/app/NewsTopline
    rm -rf /data/app/aiqiyi
    rm -rf /data/app/netflix
  fi
}

#读取配置文件
function readTreadmillConfig()
{
  config_FH3000=0
  config_HaveYsyVideo=0
  config_NoMusic=0
  config_NoFacebook=0
  config_HaveDemoVideo1=0
  config_Lang=""
  config_Logo=""

  local ConfigFolder=$preInstallDir
  local ConfigFile=`busybox ls -1 $ConfigFolder/TreadmillConfig-*.txt 2>/dev/null`
  local count=`echo "$ConfigFile" | busybox wc -l`
  if [ $count == 1 ]; then
    grep NoMusic "$ConfigFile" >/dev/null 2>&1 && config_NoMusic=1
    grep HaveYsyVideo "$ConfigFile" >/dev/null 2>&1 && config_HaveYsyVideo=1
    grep FH3000 "$ConfigFile" >/dev/null 2>&1 && config_FH3000=1
    grep NoFacebook "$ConfigFile" >/dev/null 2>&1 && config_NoFacebook=1
    HaveDemoVideo1=2
    grep HaveDemoVideo1 "$ConfigFile" >/dev/null 2>&1 && HaveDemoVideo1=1
    config_Lang=`grep "^Language" "$ConfigFile" | busybox tr -d ' \r' | busybox awk -F '[: ]+' '{print $2}'`
    config_Logo=`grep "^logo" "$ConfigFile" | busybox tr -d ' \r' | busybox awk -F '[: ]+' '{print $2}' | busybox tr '[a-z]' '[A-Z]'`
    type readAppConfig >/dev/null
    [ $? == 0 ] && readAppConfig "$ConfigFile"
  fi
  
  [ "$config_Lang" == "" ] && config_Lang="zh_CN"

  FH3000=$config_FH3000
  HaveYsyVideo=$config_HaveYsyVideo
  NoMusic=$config_NoMusic
  NoFacebook=$config_NoFacebook
  HaveDemoVideo1=$config_HaveDemoVideo1
}

function installTreadmillApp()
{
  local UI=$1
  if [ "$UI" == "" ]; then
    return
  fi
  local apk=`busybox ls -1 -t $preInstallDir/ZY-Treadmill/ZY-Treadmill-${UI}-v*.apk 2>/dev/null | busybox head -1`
  if [ "$apk" == "" ]; then
    return
  fi
  am force-stop com.ttpaobu.zhongyang.panelui >/dev/null 2>&1
  am force-stop com.zhongyang.treadmill >/dev/null 2>&1
  pm uninstall com.ttpaobu.zhongyang.panelui >/dev/null 2>&1
  pm uninstall com.zhongyang.indoorbike >/dev/null 2>&1
  pm uninstall com.zhongyang.rowing >/dev/null 2>&1
  
  echo "${str_installing_treadmill_app}"
  if [ $sdk -gt 19 ]; then
      mkdir /system/app/ZY-Treadmill/ >/dev/null 2>&1
      chmod 755 /system/app/ZY-Treadmill/
      rm -rf /system/app/ZY-Treadmill/*.apk >/dev/null 2>&1
      rm -rf /system/app/ZY-Treadmill/*.dm >/dev/null 2>&1
      cp $apk  /system/app/ZY-Treadmill/core.apk
      chmod 644 /system/app/ZY-Treadmill/core.apk
  else
      rm -rf /system/app/ZY-Treadmill* >/dev/null 2>&1
      cp $apk  /system/app/ZY-Treadmill.apk
      chmod 644 /system/app/ZY-Treadmill.apk
  fi
  pm install -r -d $apk >/dev/null 2>&1
}

function installIndoorBikeApp()
{
  local UI=$1
  if [ "$UI" == "" ]; then
    return
  fi
  local apk=`busybox ls -1 -t $preInstallDir/ZY-Treadmill/ZY-IndoorBike-${UI}-v*.apk 2>/dev/null | busybox head -1`
  if [ "$apk" == "" ]; then
    return
  fi
  am force-stop com.ttpaobu.zhongyang.panelui >/dev/null 2>&1
  am force-stop com.zhongyang.treadmill >/dev/null 2>&1
  
  pm uninstall com.ttpaobu.zhongyang.panelui >/dev/null 2>&1
  pm uninstall com.zhongyang.treadmill >/dev/null 2>&1
  pm uninstall com.zhongyang.rowing >/dev/null 2>&1
  
  echo "${str_installing_indoorbike_app}"
  if [ $sdk -gt 19 ]; then
      mkdir /system/app/ZY-Treadmill/ >/dev/null 2>&1
      chmod 755 /system/app/ZY-Treadmill/
      rm -rf /system/app/ZY-Treadmill/*.apk >/dev/null 2>&1
      rm -rf /system/app/ZY-Treadmill/*.dm >/dev/null 2>&1
      cp $apk  /system/app/ZY-Treadmill/core.apk
      chmod 644 /system/app/ZY-Treadmill/core.apk
  else
      rm -rf /system/app/ZY-Treadmill* >/dev/null 2>&1
      cp $apk  /system/app/ZY-Treadmill.apk
      chmod 644 /system/app/ZY-Treadmill.apk
  fi
  pm install -r -d $apk >/dev/null 2>&1
}

function installStairMachineApp()
{
  local UI=$1
  if [ "$UI" == "" ]; then
    return
  fi
  local apk=`busybox ls -1 -t $preInstallDir/ZY-Treadmill/ZY-StairMachine-${UI}-v*.apk 2>/dev/null | busybox head -1`
  if [ "$apk" == "" ]; then
    return
  fi
  am force-stop com.ttpaobu.zhongyang.panelui >/dev/null 2>&1
  am force-stop com.zhongyang.treadmill >/dev/null 2>&1
  pm uninstall com.ttpaobu.zhongyang.panelui >/dev/null 2>&1
  pm uninstall com.zhongyang.indoorbike >/dev/null 2>&1
  pm uninstall com.zhongyang.rowing >/dev/null 2>&1
  
  echo "${str_installing_stairmachine_app}"
  if [ $sdk -gt 19 ]; then
      mkdir /system/app/ZY-Treadmill/ >/dev/null 2>&1
      chmod 755 /system/app/ZY-Treadmill/
      rm -rf /system/app/ZY-Treadmill/*.apk >/dev/null 2>&1
      rm -rf /system/app/ZY-Treadmill/*.dm >/dev/null 2>&1
      cp $apk  /system/app/ZY-Treadmill/core.apk
      chmod 644 /system/app/ZY-Treadmill/core.apk
  else
      rm -rf /system/app/ZY-Treadmill* >/dev/null 2>&1
      cp $apk  /system/app/ZY-Treadmill.apk
      chmod 644 /system/app/ZY-Treadmill.apk
  fi
  pm install -r -d $apk >/dev/null 2>&1
}

function installRowingApp()
{
  local UI=$1
  if [ "$UI" == "" ]; then
    return
  fi
  local apk=`busybox ls -1 -t $preInstallDir/ZY-Treadmill/ZY-RowingMachine-${UI}-v*.apk 2>/dev/null | busybox head -1`
  if [ "$apk" == "" ]; then
    return
  fi
  am force-stop com.ttpaobu.zhongyang.panelui >/dev/null 2>&1
  am force-stop com.zhongyang.treadmill >/dev/null 2>&1
  pm uninstall com.ttpaobu.zhongyang.panelui >/dev/null 2>&1
  pm uninstall com.zhongyang.treadmill >/dev/null 2>&1
  pm uninstall com.zhongyang.indoorbike >/dev/null 2>&1
  
  echo "${str_installing_rowing_app}"
  if [ $sdk -gt 19 ]; then
      mkdir /system/app/ZY-Treadmill/ >/dev/null 2>&1
      chmod 755 /system/app/ZY-Treadmill/
      rm -rf /system/app/ZY-Treadmill/*.apk >/dev/null 2>&1
      rm -rf /system/app/ZY-Treadmill/*.dm >/dev/null 2>&1
      cp $apk  /system/app/ZY-Treadmill/core.apk
      chmod 644 /system/app/ZY-Treadmill/core.apk
  else
      rm -rf /system/app/ZY-Treadmill* >/dev/null 2>&1
      cp $apk  /system/app/ZY-Treadmill.apk
      chmod 644 /system/app/ZY-Treadmill.apk
  fi
  pm install -r -d $apk >/dev/null 2>&1
}

function installStrengthTrainerApp()
{
  local UI=$1
  if [ "$UI" == "" ]; then
    return
  fi
  local apk=`busybox ls -1 -t $preInstallDir/ZY-Treadmill/ZY-StrengthTrainer-${UI}-v*.apk 2>/dev/null | busybox head -1`
  if [ "$apk" == "" ]; then
    return
  fi
  am force-stop com.ttpaobu.zhongyang.panelui >/dev/null 2>&1
  am force-stop com.zhongyang.treadmill >/dev/null 2>&1
  pm uninstall com.ttpaobu.zhongyang.panelui >/dev/null 2>&1
  pm uninstall com.zhongyang.treadmill >/dev/null 2>&1
  pm uninstall com.zhongyang.indoorbike >/dev/null 2>&1
  echo "${str_installing_strengthtrainer_app}"
  
  if [ $sdk -gt 19 ]; then
      mkdir /system/app/ZY-Treadmill/ >/dev/null 2>&1
      chmod 755 /system/app/ZY-Treadmill/
      rm -rf /system/app/ZY-Treadmill/*.apk >/dev/null 2>&1
      rm -rf /system/app/ZY-Treadmill/*.dm >/dev/null 2>&1
      cp $apk  /system/app/ZY-Treadmill/core.apk
      chmod 644 /system/app/ZY-Treadmill/core.apk
  else
      rm -rf /system/app/ZY-Treadmill* >/dev/null 2>&1
      cp $apk  /system/app/ZY-Treadmill.apk
      chmod 644 /system/app/ZY-Treadmill.apk
  fi

  pm install -r -d $apk >/dev/null 2>&1
}

function checkSize()
{
  if [ ! -e $2 ]; then
    return 2
  fi

  local size1=`busybox ls -l $1 | busybox awk '{print $5}'`
  local size2=`busybox ls -l $2 | busybox awk '{print $5}'`
  if [ $size1 == $size2 ]; then
    return 0
  else
    return 1
  fi
}

function checkSame()
{
  if [ ! -e $2 ]; then
    return 2
  fi
  local result1=`busybox md5sum $1 | busybox awk '{print $1}'`
  local result2=`busybox md5sum $2 | busybox awk '{print $1}'`

  if [ x$result1 == "x" ] || [ x$result2 == "x" ]; then
    return 2
  fi
  if [ "$result1" == "$result2" ]; then
    return 0
  else
    return 1
  fi
}

function copyFile()
{
  local src=$1
  [ ! -e "$src" ] && return
  local dest=$2
  checkSize $src $dest
  local result=$?
  if [ $result != 0 ]; then
    echo ${str_copy}${src##*/}
    cp -rf $src $dest
  fi
}

function copyFile2()
{
  local src=$1
  [ ! -e "$src" ] && return
  local dest=$2
  checkSame $src $dest
  local result=$?
  if [ $result == 0 ]; then
    checkSize $src $dest
    result=$?
  fi
  if [ $result != 0 ]; then
    echo ${str_copy}${src##*/}
    cp -rf $src $dest
  fi
}

function isExistApp()
{
  local out=`pm path $1`
  local result=$?
  if [ "$out" != "" ]; then
    echo -n 1
    return 0
  else
    echo -n 0
    return 1
  fi
}

function getAppVerByPackage()
{
  local pkgName=$1
  local result=`dumpsys package $pkgName | busybox grep versionName | busybox head -1 | busybox awk -F '=' '{print $2}' | busybox sed 's/[ ]\{1,10\}/_/g'`
  echo $result
}

function getAppVerByFileName()
{
  local apk=${1##*/}
  local temp=${apk##*_v}
  if [ "$apk" == "$temp" ]; then
    echo 0
    return 1
  fi
  temp=${temp%.*}
  echo $temp
}

function copyAppToPreinstall()
{
  local pkgName=$1
  local apk=$2
  if [ ! -e "$apk" ]; then
    return
  fi

  if [ $sdk -gt 19 ]; then
    mkdir $folder_preinstall/${pkgName} >/dev/null 2>&1
    chmod 755 $folder_preinstall/${pkgName}
    copyFile "$apk"  $folder_preinstall/${pkgName}/base.apk
    chmod 644 $folder_preinstall/${pkgName}/base.apk
  else
    copyFile "$apk"  $folder_preinstall/${pkgName}.apk
    chmod 644 $folder_preinstall/${pkgName}.apk
  fi
}

function installAPK()
{
   local pkgName=$1
   local result1=`getAppVerByPackage $pkgName`
   local apk=$2
   if [ "$apk" == "" ]; then
    return
   fi

   local ext=${apk##*.}
   if [ "$ext" == "xapk" ]; then
     installXAPK $1 $2 $3
     return
   fi
    
   local result2=`getAppVerByFileName $apk`
   log -t "autoinstall" "$pkgName result1=$result1"
   log -t "autoinstall" "$pkgName result2=$result2"

   if [ "$result1" != "$result2" ]; then
     echo $3

     pm uninstall "$pkgName" >/dev/null 2>&1
     pm install -r -d "$apk" >/dev/null 2>&1
   fi
}

function installXAPK()
{
  local busybox_meefik="$preInstallDir/busybox-meefik_v1.31.1"
  if [ ! -e /system/bin/busybox-meefik ]; then
    cp -rf $busybox_meefik "/system/bin/busybox-meefik"
    chmod 755 "/system/bin/busybox-meefik"
  fi
  
  if [ ! -e /system/bin/busybox-meefik ]; then
    return
  fi
  
  local filePath=$2
  if [ ! -e "$filePath" ]; then
    return
  fi

  local pkgName=$1
  
  local result1=`dumpsys package $pkgName | busybox grep versionName | busybox head -1 | busybox awk -F '=' '{print $2}' | busybox sed 's/[ ]\{1,10\}/_/g'`
  local result2=`getAppVerByFileName $filePath`
  if [ "v$result1" == "v$result2" ]; then
    return
  fi

  local file=${filePath##*/}
  local fileName=${file%.*}
  local fileExt=${file##*.}

  log -t "autoinstall" "$pkgName result1=$result1"
  log -t "autoinstall" "$pkgName result2=$result2"

  echo $3

  pm uninstall $pkgName >/dev/null 2>&1


  local folder="/data/local/tmp/$fileName"
  mkdir $folder >/dev/null 2>&1
  busybox-meefik unzip -o -q "$filePath" -d $folder

  local result="$(pm install-create '-r')"
  local session_id=`echo "$result" | busybox grep -E -o '[0-9]+'`
  #echo "session_id=$session_id"
  for apk in $folder/*.apk
  do
    if [[ $apk != *"*.apk" ]]; then
      split_name=${apk##*/}
      pm install-write $session_id "$split_name" "$apk" >/dev/null 2>&1
    fi
  done

  pm install-commit $session_id >/dev/null 2>&1

  cp -rf "$folder/Android" /sdcard/ >/dev/null 2>&1

  rm -rf "$folder"
}

function installSpotify()
{
  if [ -e /data/app/Spotify ]; then
    rm -rf /data/app/Spotify*
    pm uninstall com.spotify.music >/dev/null 2>&1
  fi
  local pkgName="com.spotify.music"
  copy="0"
  apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.*apk 2>/dev/null | busybox head -1`
  if [ $sdk -le 19 ]; then
    apk=`busybox ls -1 -t $preInstallDir/3rd/19/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
    copy="1"
  fi
  installAPK $pkgName $apk "${str_installing_spotify}"
  [ "$copy" == "1" ] && copyAppToPreinstall $pkgName $apk
}

function installFacebook()
{
  if [ -e /data/app/Facebook ];then
   rm -rf /data/app/Facebook*
   pm uninstall com.facebook.katana >/dev/null 2>&1
  fi
  local pkgName="com.facebook.katana"

  local apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  if [ $sdk -le 19 ]; then
    apk=`busybox ls -1 -t $preInstallDir/3rd/19/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  fi
  if [ "$apk" == "" ]; then
    return
  fi
  installAPK $pkgName "$apk" "${str_installing_facebook}"
  [ "$1" == "1" ] && copyAppToPreinstall $pkgName $apk
}

function installTwitter()
{
  local pkgName="com.twitter.android"
  local apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  if [ $sdk -le 19 ]; then
    apk=`busybox ls -1 -t $preInstallDir/3rd/19/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  fi
  if [ $sdk -ge 23 ]; then
    apk=`busybox ls -1 -t $preInstallDir/3rd/23/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  fi
  if [ "$apk" == "" ]; then
    return
  fi
  installAPK $pkgName $apk "${str_installing_twitter}"
  [ "$1" == "1" ] && copyAppToPreinstall $pkgName $apk
}

function installPrimeVideo()
{
  local pkgName="com.amazon.avod.thirdpartyclient"
  local apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  if [ $sdk -le 19 ]; then
    apk=`busybox ls -1 -t $preInstallDir/3rd/19/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  fi
  if [ "$apk" == "" ]; then
    return
  fi  
  installAPK $pkgName $apk "${str_installing_primevideo}"
  [ "$1" == "1" ] && copyAppToPreinstall $pkgName $apk
}

function installChrome()
{
  local pkgName="com.android.chrome"
  local apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  if [ $sdk -le 19 ]; then
    apk=`busybox ls -1 -t $preInstallDir/3rd/19/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  fi
  if [ "$apk" == "" ]; then
    return
  fi
  installAPK $pkgName $apk "${str_installing_chrome}"
  [ "$1" == "1" ] && copyAppToPreinstall $pkgName $apk
}

function installNetflix()
{
  local pkgName="com.netflix.mediaclient"
  apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  if [ $sdk -gt 25 ]; then
    apk=`busybox ls -1 -t $preInstallDir/3rd/26/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  fi
  if [ "$apk" == "" ]; then
    return
  fi
  installAPK $pkgName $apk "${str_installing_netflix}"
  [ "$1" == "1" ] && copyAppToPreinstall $pkgName $apk
}

function installKXCast()
{
  local pkgName="com.cloudsiva.kx.cast"
  local apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  if [ "$apk" == "" ]; then
    return
  fi
  installAPK $pkgName $apk "${str_installing_kx_cast}"
  [ "$1" == "1" ] && copyAppToPreinstall $pkgName $apk
}

function installDianShiJia()
{
  if [ $sdk -ge 28 ]; then
    local pkgName="com.dianshijia.newlive"
    local apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
    if [ "$apk" == "" ]; then
      return
    fi
    installAPK $pkgName $apk "${str_installing_dsj3}"
    [ "$1" == "1" ] && copyAppToPreinstall $pkgName $apk
    pm uninstall com.elinkway.tvlive2 >/dev/null 2>&1
    rm -rf $folder_preinstall/com.elinkway.tvlive2*
  else
    local pkgName="com.elinkway.tvlive2"
    local apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
    if [ "$apk" == "" ]; then
      return
    fi
    installAPK $pkgName $apk "${str_installing_dsj2}"
    [ "$1" == "1" ] && copyAppToPreinstall $pkgName $apk
    pm uninstall com.dianshijia.newlive >/dev/null 2>&1
    rm -rf $folder_preinstall/com.dianshijia.newlive*
  fi
}

function installQQMusicHD()
{
  local pkgName="com.tencent.qqmusicpad"
  local apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  if [ "$apk" == "" ]; then
    return
  fi  
  installAPK $pkgName $apk "${str_installing_qqmusichd}"
  [ "$1" == "1" ] && copyAppToPreinstall $pkgName $apk
}

function installQiyi()
{
  local pkgName="com.qiyi.video.pad"
  local apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  if [ "$apk" == "" ]; then
    return
  fi  
  installAPK $pkgName $apk "${str_installing_iqiyi}"
  [ "$1" == "1" ] && copyAppToPreinstall $pkgName $apk
}

function installQQBrowser()
{
  local pkgName="com.tencent.mtt"
  local apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  if [ "$apk" == "" ]; then
    return
  fi  
  installAPK $pkgName $apk "${str_installing_qqbrowser}"
  [ "$1" == "1" ] && copyAppToPreinstall $pkgName $apk
}

function installNewsTopline()
{
  local pkgName="com.ss.android.article.news"
  local apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  if [ $sdk -ge 27 ]; then
    apk=`busybox ls -1 -t $preInstallDir/3rd/28/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  fi
  if [ "$apk" == "" ]; then
    return
  fi  
  installAPK $pkgName $apk "${str_installing_newstop}"
  [ "$1" == "1" ] && copyAppToPreinstall $pkgName $apk
}

function installBaidu()
{
  local pkgName="com.baidu.searchbox"
  local apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  if [ $sdk -ge 28 ]; then
    apk=`busybox ls -1 -t $preInstallDir/3rd/28/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  fi
  if [ "$apk" == "" ]; then
    return
  fi  
  installAPK $pkgName $apk "${str_installing_baidu}"
  [ "$1" == "1" ] && copyAppToPreinstall $pkgName $apk
}

function installLeBo()
{
  local pkgName="com.hpplay.happyplay.aw"
  local apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  if [ "$apk" == "" ]; then
    return
  fi  
  installAPK $pkgName $apk "${str_installing_lebo}"
  [ "$1" == "1" ] && copyAppToPreinstall $pkgName $apk
}

function installYoutube()
{
  local pkgName="com.google.android.youtube"
  local apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  if [ $sdk -le 19 ]; then
    apk=`busybox ls -1 -t $preInstallDir/3rd/19/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  fi
  if [ $sdk -ge 23 ]; then
    apk=`busybox ls -1 -t $preInstallDir/3rd/23/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  fi
  if [ $sdk -ge 26 ]; then
    apk=`busybox ls -1 -t $preInstallDir/3rd/26/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  fi
  if [ "$apk" == "" ]; then
    return
  fi
  dumpsys package $pkgName | grep "com.google.android.providers.gsf.permission.READ_GSERVICES" >/dev/null 2>&1
  if [ $? != 0 ]; then
    pm uninstall $pkgName >/dev/null 2>&1
  fi
  installAPK $pkgName $apk "${str_installing_youtube}"
  [ "$1" == "1" ] && copyAppToPreinstall $pkgName $apk
}

function installPlayStore()
{
  local pkgName="com.android.vending"
  local apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  if [ $sdk -le 19 ]; then
    apk=`busybox ls -1 -t $preInstallDir/3rd/19/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  fi
  if [ "$apk" == "" ]; then
    return
  fi
  installAPK $pkgName $apk "${str_installing_new_googlestore}"
  #copyAppToPreinstall $pkgName $apk
}

function installGooglePlay()
{
  if [ $sdk -ge 23 ]; then
    return
  fi
  Files22=(
    "96dba959ec7d0a85877c5d0787c771d1  /system/priv-app/GmsCore/GmsCore.apk"
    "a19e4e964b29c58704a396b6df87d74f  /system/priv-app/GoogleBackupTransport/GoogleBackupTransport.apk"
    "d60e3c9b8fc59977bf58da0ab3ec62b9  /system/priv-app/GoogleFeedback/GoogleFeedback.apk"
    "fe0627491c199c1b65615f1a5c2c90b6  /system/priv-app/GoogleLoginService/GoogleLoginService.apk"
    "d426b1e14ca81bc9190ad4293cb2c084  /system/priv-app/GoogleOneTimeInitializer/GoogleOneTimeInitializer.apk"
    "3fe67289cfc1f824183326143bfc52a8  /system/priv-app/GooglePartnerSetup/GooglePartnerSetup.apk"
    "e2b560fb18ee8d32e5f28ec50e9f66b2  /system/priv-app/GoogleServicesFramework/GoogleServicesFramework.apk"
    "e0f29f06e556e1979a27b37d5b2a1eeb  /system/priv-app/Phonesky/Phonesky.apk"
    "42e7e5ec4c111228c600a253d5e1c45b  /system/priv-app/GmsCore/lib/arm/libAppDataSearch.so"
    "f4975dd8480e0f0b18fc34fd2f6b3f9b  /system/priv-app/GmsCore/lib/arm/libWhisper.so"
    "21d4fc2ea222a250ba206e634c72535d  /system/priv-app/GmsCore/lib/arm/libconscrypt_gmscore_jni.so"
    "15e5ac644da73d926ca89449c2d73c55  /system/priv-app/GmsCore/lib/arm/libgcastv2_base.so"
    "d4753c2b2c3a21d43eb7cf02e50ad923  /system/priv-app/GmsCore/lib/arm/libgcastv2_support.so"
    "689f5f728a2323999bcefb04849cf7f0  /system/priv-app/GmsCore/lib/arm/libgmscore.so"
    "b062fa1c6e516abc0f338c156f678cfd  /system/priv-app/GmsCore/lib/arm/libgoogle-ocrclient-v3.so"
    "2e0bf6016f4a04260f85bf2bb6fa2351  /system/priv-app/GmsCore/lib/arm/libjgcastservice.so"
    "0986b67dd7c7ae705fd1849224e8984e  /system/priv-app/GmsCore/lib/arm/libleveldbjni.so"
    "df22db7d4024ade739c1e47d77043a0b  /system/priv-app/GmsCore/lib/arm/libvcdiffjni.so"
    "33b55169290cdd4811603986b67e6e1d  /system/priv-app/GmsCore/lib/arm/libwearable-selector.so"
    "6ab612fceebeda79a7dc1cf2c68d0f12  /system/framework/com.google.android.camera2.jar"
    "c43fcbff49500da476cd7cb51f449e23  /system/framework/com.google.android.maps.jar"
    "e8bef31ab52ecb14a3d1de24014c1968  /system/framework/com.google.android.media.effects.jar"
    "6a6eb7d7c7411708d427a1b42acc970f  /system/framework/com.google.widevine.software.drm.jar"
  )

  Files19=(
    "96dba959ec7d0a85877c5d0787c771d1  /system/priv-app/GmsCore.apk"
    "e880fb419919b30dd38a638c828e6d0b  /system/priv-app/GoogleBackupTransport.apk"
    "e7e8d97ad5206056cfdfb74a82e5b659  /system/priv-app/GoogleContactsSyncAdapter.apk"
    "549aa78641bc407db1041a59787ea345  /system/priv-app/GoogleFeedback.apk"
    "10f2423d70c54b4ade3a0e101dc53154  /system/priv-app/GoogleLoginService.apk"
    "1c9b8da36a82746039602c1c354a566b  /system/priv-app/GooglePartnerSetup.apk"
    "e3afa1d83f54c56870359821ad5b2aaf  /system/priv-app/GoogleServicesFramework.apk"
    "e0f29f06e556e1979a27b37d5b2a1eeb  /system/priv-app/Phonesky.apk"
    "42e7e5ec4c111228c600a253d5e1c45b  /system/lib/libAppDataSearch.so"
    "f4975dd8480e0f0b18fc34fd2f6b3f9b  /system/lib/libWhisper.so"
    "21d4fc2ea222a250ba206e634c72535d  /system/lib/libconscrypt_gmscore_jni.so"
    "15e5ac644da73d926ca89449c2d73c55  /system/lib/libgcastv2_base.so"
    "d4753c2b2c3a21d43eb7cf02e50ad923  /system/lib/libgcastv2_support.so"
    "689f5f728a2323999bcefb04849cf7f0  /system/lib/libgmscore.so"
    "b062fa1c6e516abc0f338c156f678cfd  /system/lib/libgoogle-ocrclient-v3.so"
    "2e0bf6016f4a04260f85bf2bb6fa2351  /system/lib/libjgcastservice.so"
    "0986b67dd7c7ae705fd1849224e8984e  /system/lib/libleveldbjni.so"
    "df22db7d4024ade739c1e47d77043a0b  /system/lib/libvcdiffjni.so"
    "33b55169290cdd4811603986b67e6e1d  /system/lib/libwearable-selector.so"
    "6ab612fceebeda79a7dc1cf2c68d0f12  /system/framework/com.google.android.camera2.jar"
    "c43fcbff49500da476cd7cb51f449e23  /system/framework/com.google.android.maps.jar"
    "e8bef31ab52ecb14a3d1de24014c1968  /system/framework/com.google.android.media.effects.jar"
    "6a6eb7d7c7411708d427a1b42acc970f  /system/framework/com.google.widevine.software.drm.jar"
  )
  Files23=()
  Files=( "${Files22[@]}" )
  if [ $sdk -le 19 ]; then
    Files=( "${Files19[@]}" )
  fi
  if [ $sdk -ge 23 ]; then
    Files=( "${Files23[@]}" )
  fi
  echo "${str_checking_google_play}"
  local needReinstall=0
  for i in ${!Files[@]}; do
    file=${Files[i]}
    filePath=`echo $file | busybox awk '{print $2}'`
    if [ ! -e $filePath ]; then
      needReinstall=1
      break
    fi
    local MD5=$file

    local currentMD5=`busybox md5sum $filePath`
    if [ "$MD5" !=  "$currentMD5" ]; then
      needReinstall=1
      break
    fi
  done

  if [ $needReinstall == 0 ]; then
    return
  fi

  echo "${str_installing_google_play}"

  am force-stop com.google.android.gms >/dev/null 2>&1
  am force-stop com.google.android.gsf >/dev/null 2>&1

  if [ $sdk -eq 19 ]; then
    cp -f $preInstallDir/system-google/framework/*.jar  /system/framework/

    cp -f $preInstallDir/system-google/etc/permissions/*.xml  /system/etc/permissions/

    cp -rf $preInstallDir/system-google/etc/preferred-apps  /system/etc/

    cp -f $preInstallDir/system-google/priv-app/19/GoogleBackupTransport.apk  /system/priv-app/
    cp -f $preInstallDir/system-google/priv-app/19/GoogleFeedback.apk  /system/priv-app/
    cp -f $preInstallDir/system-google/priv-app/19/GoogleLoginService.apk  /system/priv-app/
    cp -f $preInstallDir/system-google/priv-app/19/GooglePartnerSetup.apk  /system/priv-app/
    cp -f $preInstallDir/system-google/priv-app/19/GoogleServicesFramework.apk  /system/priv-app/
    cp -f $preInstallDir/system-google/priv-app/Phonesky/Phonesky.apk  /system/priv-app/
    #cp -f $preInstallDir/system-google/priv-app/GoogleOneTimeInitializer/GoogleOneTimeInitializer.apk  /system/priv-app/
    cp -f $preInstallDir/system-google/priv-app/19/GoogleContactsSyncAdapter.apk  /system/priv-app/


    rm -rf /system/priv-app/PrebuiltGmsCore.apk
    rm -rf /system/app/GmsCore.apk
    cp -f $preInstallDir/system-google/priv-app/GmsCore/GmsCore.apk  /system/priv-app/GmsCore.apk
    cp -f $preInstallDir/system-google/priv-app/GmsCore/lib/arm/*  /system/lib/
    chmod 644 /system/lib/libAppDataSearch.so
    chmod 644 /system/lib/libconscrypt_gmscore_jni.so
    chmod 644 /system/lib/libgcastv2_base.so
    chmod 644 /system/lib/libgcastv2_support.so
    chmod 644 /system/lib/libgmscore.so
    chmod 644 /system/lib/libgoogle-ocrclient-v3.so
    chmod 644 /system/lib/libjgcastservice.so
    chmod 644 /system/lib/libleveldbjni.so
    chmod 644 /system/lib/libvcdiffjni.so
    chmod 644 /system/lib/libwearable-selector.so
    chmod 644 /system/lib/libWhisper.so
    chmod 644 /system/priv-app/Google*.apk
    chmod 644 /system/priv-app/Phonesky.apk
    chmod 644 /system/priv-app/GmsCore.apk

    chmod 644 /system/framework/com.google.*.jar

    chmod 644 /system/etc/permissions/com.google.*.xml

    chmod 755 /system/etc/preferred-apps
    chmod 644 /system/etc/preferred-apps/*.xml

    pm install $preInstallDir/system-google/priv-app/19/GoogleServicesFramework.apk >/dev/null 2>&1

  elif [ $sdk -eq 22 ]; then
    cp -rf $preInstallDir/system-google/framework/*.jar  /system/framework/

    cp -rf $preInstallDir/system-google/etc/permissions/*.xml  /system/etc/permissions/

    cp -rf $preInstallDir/system-google/etc/preferred-apps  /system/etc/

    cp -rf $preInstallDir/system-google/priv-app/GoogleBackupTransport  /system/priv-app/
    cp -rf $preInstallDir/system-google/priv-app/GoogleFeedback  /system/priv-app/
    cp -rf $preInstallDir/system-google/priv-app/GoogleLoginService  /system/priv-app/
    cp -rf $preInstallDir/system-google/priv-app/GooglePartnerSetup  /system/priv-app/
    cp -rf $preInstallDir/system-google/priv-app/GoogleServicesFramework  /system/priv-app/
    cp -rf $preInstallDir/system-google/priv-app/Phonesky  /system/priv-app/
    cp -rf $preInstallDir/system-google/priv-app/GoogleOneTimeInitializer  /system/priv-app/


    rm -rf /system/priv-app/PrebuiltGmsCore
    rm -rf /system/app/GmsCore
    cp -rf $preInstallDir/system-google/priv-app/GmsCore  /system/priv-app
    chmod 755 /system/priv-app/GmsCore/lib
    chmod 755 /system/priv-app/GmsCore/lib/arm
    chmod 644 /system/priv-app/GmsCore/lib/arm/*

    chmod 755 /system/priv-app/GoogleBackupTransport
    chmod 755 /system/priv-app/GoogleFeedback
    chmod 755 /system/priv-app/GoogleLoginService
    chmod 755 /system/priv-app/GooglePartnerSetup
    chmod 755 /system/priv-app/GoogleServicesFramework
    chmod 755 /system/priv-app/Phonesky
    #chmod 755 /system/priv-app/SetupWizard/SetupWizard.apk
    chmod 755 /system/priv-app/GoogleOneTimeInitializer
    chmod 755 /system/priv-app/GmsCore

    chmod 644 /system/priv-app/GoogleBackupTransport/GoogleBackupTransport.apk
    chmod 644 /system/priv-app/GoogleFeedback/GoogleFeedback.apk
    chmod 644 /system/priv-app/GoogleLoginService/GoogleLoginService.apk
    chmod 644 /system/priv-app/GooglePartnerSetup/GooglePartnerSetup.apk
    chmod 644 /system/priv-app/GoogleServicesFramework/GoogleServicesFramework.apk
    chmod 644 /system/priv-app/Phonesky/Phonesky.apk
    chmod 644 /system/priv-app/GoogleOneTimeInitializer/GoogleOneTimeInitializer.apk
    chmod 644 /system/priv-app/GmsCore/GmsCore.apk

    chmod 644 /system/framework/com.google.*.jar

    chmod 644 /system/etc/permissions/com.google.*.xml

    chmod 755 /system/etc/preferred-apps
    chmod 644 /system/etc/preferred-apps/*.xml

    rm -rf /system/priv-app/Google*/arm >/dev/null 2>&1
    rm -rf /system/priv-app/GmsCore/arm >/dev/null 2>&1
    rm -rf /system/priv-app/GmsCore/lib/armeabi-v7a >/dev/null 2>&1
    
    pm install $preInstallDir/system-google/priv-app/GoogleServicesFramework/GoogleServicesFramework.apk >/dev/null 2>&1
  fi
  
  pm install $preInstallDir/system-google/priv-app/GmsCore/GmsCore.apk >/dev/null 2>&1

  pm clear com.google.android.gms >/dev/null 2>&1
}

function removeGooglePlayService()
{
    if [ $sdk -le 22 ]; then
        pm uninstall com.google.android.gsf >/dev/null 2>&1
        pm uninstall com.google.android.gms >/dev/null 2>&1
        pm uninstall com.android.vending >/dev/null 2>&1
          
        rm -rf /system/priv-app/GoogleBackupTransport >/dev/null 2>&1
        rm -rf /system/priv-app/GoogleFeedback >/dev/null 2>&1
        rm -rf /system/priv-app/GoogleLoginService >/dev/null 2>&1
        rm -rf /system/priv-app/GooglePartnerSetup >/dev/null 2>&1
        rm -rf /system/priv-app/GoogleServicesFramework >/dev/null 2>&1
        rm -rf /system/priv-app/GoogleOneTimeInitializer >/dev/null 2>&1
        rm -rf /system/priv-app/GmsCore >/dev/null 2>&1
        rm -rf /system/priv-app/Phonesky >/dev/null 2>&1
        rm -rf /system/priv-app/PrebuiltGmsCore

        rm -rf /data/dalvik-cache/arm/*oogle*.dex
    fi    
}
#19 4.4
#22 5.1
#23 6.0
#24 7.0
#25 7.1
#27 8.1
#28 9.0
#29 10.0
function installNewGMS()
{
  local versionName1=`getAppVerByPackage com.google.android.gms`
  if [ $sdk -eq 19 ]; then
    apk="$preInstallDir/gms/com.google.android.gms_19.8.31_(000300-284611645).apk"
    versionName2="19.8.31_(000300-284611645)"
  elif [ $sdk -eq 22 ]; then
    apk="$preInstallDir/gms/com.google.android.gms_20.15.16_(020300-309763488).apk"
    versionName2="20.15.16_(020300-309763488)"
  elif [ $sdk -eq 23 ]; then
    apk="$preInstallDir/gms/com.google.android.gms_20.15.16_(040300-309763488).apk"
    versionName2="20.15.16_(040300-309763488)"
  elif [ $sdk -eq 24 ]; then
    apk="$preInstallDir/gms/com.google.android.gms_20.15.16_(040300-309763488).apk"
    versionName2="20.15.16_(040300-309763488)"
  elif [ $sdk -eq 25 ]; then
    apk="$preInstallDir/gms/com.google.android.gms_20.15.16_(040300-309763488).apk"
    versionName2="20.15.16_(040300-309763488)"
  elif [ $sdk -eq 27 ]; then
    apk="$preInstallDir/gms/com.google.android.gms_20.39.15_(110400-335085812).apk"
    versionName2="20.39.15_(110400-335085812)"
  elif [ $sdk -eq 28 ]; then
    apk="$preInstallDir/gms/com.google.android.gms_20.39.15_(100400-335085812).apk"
    versionName2="20.39.15_(100400-335085812)"
  elif [ $sdk -eq 29 ]; then
    apk="$preInstallDir/gms/com.google.android.gms_20.39.15_(120400-335085812).apk"
    versionName2="20.39.15_(120400-335085812)"
  elif [ $sdk -gt 29 ]; then
    apk="$preInstallDir/gms/com.google.android.gms_20.39.15_(120400-335085812).apk"
    versionName2="20.39.15_(120400-335085812)"  
  fi
  
  if [ ! -e "$apk" ]; then
    return
  fi
  
  if [[ "$versionName2" > "$versionName1" ]]; then
    echo "${str_installing_new_gms}"
    pm install -r "$apk" >/dev/null 2>&1
  fi
}

function uninstallNewsTopline()
{
  pm uninstall com.ss.android.article.news >/dev/null 2>&1
  rm -rf $folder_preinstall/com.ss.android.article.news*
  rm -rf /data/app/com.ss.android.article.news*
  rm -rf /data/data/com.ss.android.article.news*
  rm -rf /data/app/netflix*
}

function removeGoogleAccounts()
{
  if [ $sdk -le 23 ]; then
    local accounts_db="/data/system/users/0/accounts.db"
    sqlite3 $accounts_db "delete from accounts;delete from sqlite_sequence;"

    am broadcast -a "android.accounts.LOGIN_ACCOUNTS_CHANGED" >/dev/null 2>&1
  fi

  if [ $sdk -ge 24 ]; then
    local accounts_ce_db="/data/system_ce/0/accounts_ce.db"
    sqlite3 $accounts_ce_db "delete from accounts;delete from sqlite_sequence;"

    local accounts_de_db="/data/system_de/0/accounts_de.db"
    sqlite3 $accounts_de_db "delete from accounts;"

    am broadcast -a "android.accounts.LOGIN_ACCOUNTS_CHANGED" >/dev/null 2>&1
  fi
}

function installAutoinstall()
{
  if [ $sdk -ge 29 ]; then
    return
  fi  
  local pkgName="com.zhongyang.autoinstall"
  local apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
  if [ ! -e "$apk" ]; then
    return
  fi

  local result1=`dumpsys package $pkgName | busybox grep versionName | busybox tail -1 | busybox awk -F '=' '{print $2}'`
  local result2=`getAppVerByFileName $apk`
  if [ "$result2" \< "$result1" ] || [ "$result2" = "$result1" ]; then
    return
  fi
  log -t "autoinstall" "$pkgName result1=$result1"
  log -t "autoinstall" "$pkgName result2=$result2"
  echo "${str_installing_autoinstall}"
  if [ $sdk -gt 19 ]; then
    mkdir /system/app/AutoInstall/ >/dev/null 2>&1
    chmod 755 /system/app/AutoInstall/
    cp -rf $apk /system/app/AutoInstall/AutoInstall.apk
    chmod 644 /system/app/AutoInstall/AutoInstall.apk
    rm -rf /system/app/AutoInstall/*.dm
  else
    cp -rf $apk /system/app/AutoInstall.apk
    chmod 644 /system/app/AutoInstall.apk
  fi
  pm install -r $apk >/dev/null 2>&1
}

function installApkInstaller()
{
  if [ ! -e $preInstallDir/systemapp/RkApkinstaller.apk ]; then
    return
  fi
  local result=`isExistApp com.android.apkinstaller`
  if [ "$result" == "0" ]; then
    echo "${str_installing_apk_installer}"
    if [ $sdk -gt 19 ]; then
      mkdir /system/app/RkApkinstaller/ >/dev/null 2>&1
      chmod 755 /system/app/RkApkinstaller/
      cp -rf $preInstallDir/systemapp/RkApkinstaller.apk /system/app/RkApkinstaller
      chmod 644 /system/app/RkApkinstaller/RkApkinstaller.apk
    else
      cp -rf $preInstallDir/systemapp/RkApkinstaller.apk /system/app/RkApkinstaller.apk
      chmod 644 /system/app/RkApkinstaller.apk
    fi
  fi
}

function installProvision()
{
  if [ ! -e $preInstallDir/systemapp/Provision.apk ]; then
    return
  fi
  local result=`isExistApp com.android.provision`
  if [ "$result" == "0" ]; then
    echo "${str_installing_provision}"
    if [ $sdk -eq 22 ]; then
      mkdir /system/app/Provision/ >/dev/null 2>&1
      chmod 755 /system/app/Provision/
      cp -rf $preInstallDir/systemapp/Provision.apk /system/app/Provision/Provision.apk
      chmod 644 /system/app/Provision/Provision.apk
    fi
  fi
}

function installPinyin()
{
  if [ $sdk -eq 22 ]; then
    if [ ! -e $preInstallDir/inputmethod/GooglePinyin ]; then
      return
    fi
    local result=`isExistApp com.google.android.inputmethod.pinyin`
    if [ "$result" == "0" ]; then
      echo "${str_installing_pinyin}"
      pm clear com.google.android.inputmethod.pinyin >/dev/null 2>&1
      local apkpath=`pm path com.google.android.inputmethod.pinyin | busybox awk -F ':' '{print $2}'`
      local apkFolder=`busybox dirname $apkpath`
      if [[ "$apkFolder" == "/system/"* ]]; then
        rm -rf $apkFolder >/dev/null 2>&1
      fi
      cp -rf $preInstallDir/inputmethod/GooglePinyin /system/app/
      chmod 755 /system/app/GooglePinyin
      chmod 755 /system/app/GooglePinyin/lib
      chmod 755 /system/app/GooglePinyin/lib/arm
      chmod 644 /system/app/GooglePinyin/*.apk
      chmod 644 /system/app/GooglePinyin/lib/arm/*.so

      pm install -r $preInstallDir/inputmethod/GooglePinyin/GooglePinyin.apk >/dev/null 2>&1
    fi
  elif [ $sdk -eq 19 ]; then
    if [ ! -e $preInstallDir/inputmethod/GooglePinyinIME ]; then
      return
    fi
    local result=`isExistApp com.android.inputmethod.pinyin`
    if [ "$result" == "0" ]; then
      echo "${str_installing_pinyin}"
      cp -f $preInstallDir/inputmethod/GooglePinyinIME/libjni_pinyinime.so /system/lib
      chmod 644 /system/lib/libjni_pinyinime.so
      cp -f $preInstallDir/inputmethod/GooglePinyinIME/PinyinIME.apk /system/app/
      chmod 644 /system/app/PinyinIME.apk
      pm install -r $preInstallDir/inputmethod/GooglePinyinIME/PinyinIME.apk >/dev/null 2>&1
    fi
  fi
}

function installZhuyin()
{
  if [ ! -e $preInstallDir/inputmethod/ZhuyinIME ]; then
    return
  fi
  local result=`isExistApp com.google.android.apps.inputmethod.zhuyin`
  if [ "$result" == "0" ]; then
    echo "${str_installing_zhuying}"
    if [ $sdk -gt 19 ]; then
        mkdir /system/app/ZhuyinIME >/dev/null 2>&1
        chmod 755 /system/app/ZhuyinIME

        cp -rf $preInstallDir/inputmethod/ZhuyinIME/lib /system/app/ZhuyinIME
        chmod 755 /system/app/ZhuyinIME/lib
        chmod 755 /system/app/ZhuyinIME/lib/arm

        chmod 644 /system/app/ZhuyinIME/lib/arm/*.so

        cp -f $preInstallDir/inputmethod/ZhuyinIME/ZhuyinIME.apk /system/app/ZhuyinIME
        chmod 644 /system/app/ZhuyinIME/ZhuyinIME.apk

        pm install -r $preInstallDir/inputmethod/ZhuyinIME/ZhuyinIME.apk >/dev/null 2>&1
    else
        local apk=$preInstallDir/inputmethod/ZhuyinIME/ZhuyinIME.apk
        pm install -r $apk >/dev/null 2>&1
        #copyAppToPreinstall "com.google.android.apps.inputmethod.zhuyin" $apk
    fi
  fi
}


function installLatin()
{
  pm enable com.android.inputmethod.latin >/dev/null 2>&1
  if [ ! -e $preInstallDir/inputmethod/LatinIME ]; then
    return
  fi
  
  local result=`isExistApp com.android.inputmethod.latin`
  if [ "$result" == "0" ]; then
    if [ $sdk -gt 19 ]; then
      echo "${str_installing_latin}"
      pm clear com.android.inputmethod.latin >/dev/null 2>&1
      apkpath=`pm path com.android.inputmethod.latin | busybox awk -F ':' '{print $2}'`
      apkFolder=`busybox dirname $apkpath`
      if [[ "$apkFolder" == "/system/"* ]]; then
        rm -rf $apkFolder >/dev/null 2>&1
      fi

      cp -rf $preInstallDir/inputmethod/LatinIME /system/app/
      chmod 755 /system/app/LatinIME
      chmod 755 /system/app/LatinIME/lib
      chmod 755 /system/app/LatinIME/lib/arm
      chmod 644 /system/app/LatinIME/*.apk
      chmod 644 /system/app/LatinIME/lib/arm/*.so
      
      pm install -r $preInstallDir/inputmethod/LatinIME/LatinIME.apk >/dev/null 2>&1
    else
      pm install -r $preInstallDir/inputmethod/LatinIME/LatinIME.apk >/dev/null 2>&1
    fi
  fi
}

function installKoreanHangul()
{
    local pkgName="com.estsoft.android.keyboard"
    local apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
    if [ -e "$apk" ]; then
        echo "${str_installing_korean_hangul}"
        if [ $sdk -gt 19 ]; then
            mkdir /system/app/KoreanHangul >/dev/null 2>&1
            chmod 755 /system/app/KoreanHangul
            cp -rf "$apk" /system/app/KoreanHangul/core.apk
            chmod 644 /system/app/KoreanHangul/core.apk
        else
            cp -rf "$apk" /system/app/KoreanHangul.apk
        fi
        pm install -r "$apk" >/dev/null 2>&1
    fi
}

function installZYInputmethod()
{
    local pkgName="com.zhongyang.inputmethod"
    local apk=`busybox ls -1 -t $preInstallDir/3rd/${pkgName}_v*.apk 2>/dev/null | busybox head -1`
    if [ -e "$apk" ]; then
        echo "${str_installing_zhongyang_softkeyboard}"
        if [ $sdk -gt 19 ]; then
            mkdir /system/app/ZY-SoftKeyboard >/dev/null 2>&1
            chmod 755 /system/app/ZY-SoftKeyboard
            cp -rf "$apk" /system/app/ZY-SoftKeyboard/core.apk
            chmod 644 /system/app/ZY-SoftKeyboard/core.apk
        else
            cp -rf "$apk" /system/app/ZY-SoftKeyboard.apk
        fi
        pm install -r "$apk" >/dev/null 2>&1
    fi
}

function installMusic()
{
  pm enable com.android.music >/dev/null 2>&1
  local result=`isExistApp com.android.music`
  if [ "$result" == "0" ]; then
    echo "${str_installing_music}"
    if [ $sdk -gt 19 ]; then
      mkdir /system/app/Music/ >/dev/null 2>&1
      chmod 755 /system/app/Music/
      cp -rf $preInstallDir/systemapp/Music.apk /system/app/Music/Music.apk
      chmod 644 /system/app/Music/Music.apk
    else
      cp -rf $preInstallDir/systemapp/Music.apk /system/app/Music.apk
      chmod 644 /system/app/Music.apk
    fi
  fi
}

function copyLibToSystem()
{
  if [ ! -e "$preInstallDir/lib" ]; then
    return
  fi
  cd $preInstallDir
  if [ $sdk -gt 19 ]; then
    mkdir /system/app/ZY-Treadmill/lib >/dev/null 2>&1
    chmod 755 /system/app/ZY-Treadmill/lib
    mkdir /system/app/ZY-Treadmill/lib/arm >/dev/null 2>&1
    chmod 755 /system/app/ZY-Treadmill/lib/arm
    for i in lib/*.so
    do
      if [ $i != "lib/*.so" ]; then
        copyFile $preInstallDir/$i  "/system/app/ZY-Treadmill/lib/arm/${i##*/}"
        chmod 644 "/system/app/ZY-Treadmill/lib/arm/${i##*/}"
      fi
    done
  else
    for i in lib/*.so
    do
      if [ $i != "lib/*.so" ]; then
        copyFile $preInstallDir/$i  "/system/lib/${i##*/}"
        chmod 644 "/system/lib/${i##*/}"
      fi
    done
  fi
  cd - >/dev/null 2>&1
}

function copyVlcLibToSystem()
{
  if [ ! -e "$preInstallDir/libvlc" ]; then
    return
  fi
  cd $preInstallDir
  if [ $sdk -gt 19 ]; then
    rm -rf /system/lib/libanw.*.so
    rm -rf /system/lib/libiomx.*.so
    rm -rf /system/lib/libmla.so
    rm -rf /system/lib/libvlc.so
    rm -rf /system/lib/libvlcjni.so

    rm -rf /system/app/ZY-Treadmill/lib/arm/libanw.*.so
    rm -rf /system/app/ZY-Treadmill/lib/arm/libiomx.*.so

    mkdir /system/app/ZY-Treadmill/lib >/dev/null 2>&1
    chmod 755 /system/app/ZY-Treadmill/lib
    mkdir /system/app/ZY-Treadmill/lib/arm >/dev/null 2>&1
    chmod 755 /system/app/ZY-Treadmill/lib/arm
    for i in libvlc/*.so
    do
      if [ $i != "libvlc/*.so" ]; then
        copyFile $preInstallDir/$i  "/system/app/ZY-Treadmill/lib/arm/${i##*/}"
        chmod 644 "/system/app/ZY-Treadmill/lib/arm/${i##*/}"
      fi
    done
  else
    rm -rf /system/lib/libanw.*.so
    rm -rf /system/lib/libiomx.*.so

    for i in libvlc/*.so
    do
      if [ $i != "libvlc/*.so" ]; then
        copyFile $preInstallDir/$i  "/system/lib/${i##*/}"
        chmod 644 "/system/lib/${i##*/}"
      fi
    done
  fi
  cd - >/dev/null 2>&1
}

function copyOldVlcLibToSystem()
{
  if [ ! -e "$preInstallDir/libvl" ]; then
    return
  fi
  cd $preInstallDir
  if [ $sdk -gt 19 ]; then
    mkdir /system/app/ZY-Treadmill/lib >/dev/null 2>&1
    chmod 755 /system/app/ZY-Treadmill/lib
    mkdir /system/app/ZY-Treadmill/lib/arm >/dev/null 2>&1
    chmod 755 /system/app/ZY-Treadmill/lib/arm

    for i in libvl/*.so
    do
      if [ $i != "libvl/*.so" ]; then
        copyFile $preInstallDir/$i  "/system/app/ZY-Treadmill/lib/arm/${i##*/}"
        chmod 644 "/system/app/ZY-Treadmill/lib/arm/${i##*/}"
      fi
    done
  else
    for i in libvl/*.so
    do
      if [ $i != "libvl/*.so" ]; then
        copyFile $preInstallDir/$i  "/system/lib/${i##*/}"
        chmod 644 "/system/lib/${i##*/}"
      fi
    done
  fi
  cd - >/dev/null 2>&1
}

function copyScene241ToSdcard()
{
  mkdir /sdcard/ZY >/dev/null 2>&1
  chmod 755 /sdcard/ZY
  mkdir /sdcard/ZY/scene >/dev/null 2>&1
  chmod 755 /sdcard/ZY/scene
  touch /sdcard/ZY/scene/.nomedia

  if [ ! -e "$preInstallDir/Media" ]; then
    return
  fi
  rm -rf /sdcard/*.mov
  rm -rf /sdcard/ZY/scene/ZY-VIDEO-5.*
  rm -rf /sdcard/ZY/scene/ZY-VIDEO-3.*
  rm -rf /sdcard/ZY/scene/ZY-VIDEO-6.*

  copyFile $preInstallDir/Media/ZY-VIDEO-2.mov  "/sdcard/ZY/scene/ZY-VIDEO-2.mov"
  copyFile $preInstallDir/Media/ZY-VIDEO-4.mov  "/sdcard/ZY/scene/ZY-VIDEO-4.mov"
  copyFile $preInstallDir/Media/ZY-VIDEO-1.mov  "/sdcard/ZY/scene/ZY-VIDEO-1.mov"

  chmod 644 /sdcard/ZY/scene/*.mov
}

function copyScene241ToSystem()
{
#  if [ $sdk -ge 29 ]; then
#    mount -o rw,remount /odm
#    mkdir -p /odm/media/scene/ >/dev/null 2>&1
#    chmod 755 /odm/media/scene/

#    rm -rf /odm/media/scene/ZY-VIDEO-5.*
#    rm -rf /odm/media/scene/ZY-VIDEO-3.*
#    rm -rf /odm/media/scene/ZY-VIDEO-6.*

#    copyFile $preInstallDir/Media/ZY-VIDEO-2.mov /odm/media/scene/ZY-VIDEO-2.mov
#    copyFile $preInstallDir/Media/ZY-VIDEO-4.mov /odm/media/scene/ZY-VIDEO-4.mov
#    copyFile $preInstallDir/Media/ZY-VIDEO-1.mov /odm/media/scene/ZY-VIDEO-1.mov

#    chmod 644 /odm/media/scene/*.mov
#  else
    mkdir -p /system/media/scene/ >/dev/null 2>&1
    chmod 755 /system/media/scene/
    
    if [ ! -e "$preInstallDir/Media" ]; then
        return
    fi

    rm -rf /system/media/scene/ZY-VIDEO-5.*
    rm -rf /system/media/scene/ZY-VIDEO-3.*
    rm -rf /system/media/scene/ZY-VIDEO-6.*

    copyFile $preInstallDir/Media/ZY-VIDEO-2.mov /system/media/scene/ZY-VIDEO-2.mov
    copyFile $preInstallDir/Media/ZY-VIDEO-4.mov /system/media/scene/ZY-VIDEO-4.mov
    copyFile $preInstallDir/Media/ZY-VIDEO-1.mov /system/media/scene/ZY-VIDEO-1.mov

    chmod 644 /system/media/scene/*.mov
#  fi
}

function copyScene245ToSdcard()
{
  mkdir /sdcard/ZY >/dev/null 2>&1
  chmod 755 /sdcard/ZY
  mkdir /sdcard/ZY/scene >/dev/null 2>&1
  chmod 755 /sdcard/ZY/scene
  touch /sdcard/ZY/scene/.nomedia
  
  if [ ! -e "$preInstallDir/Media" ]; then
    return
  fi

  rm -rf /sdcard/*.mov
  rm -rf /sdcard/ZY/scene/ZY-VIDEO-1.*
  rm -rf /sdcard/ZY/scene/ZY-VIDEO-3.*
  rm -rf /sdcard/ZY/scene/ZY-VIDEO-6.*

  copyFile $preInstallDir/Media/ZY-VIDEO-2.mov  "/sdcard/ZY/scene/ZY-VIDEO-2.mov"
  copyFile $preInstallDir/Media/ZY-VIDEO-4.mov  "/sdcard/ZY/scene/ZY-VIDEO-4.mov"
  copyFile $preInstallDir/Media/ZY-VIDEO-5.mov  "/sdcard/ZY/scene/ZY-VIDEO-5.mov"
  chmod 644 /sdcard/ZY/scene/*.mov
}

function copyScene245ToSystem()
{
#  if [ $sdk -ge 29 ]; then
#    mount -o rw,remount /odm
#    mkdir -p /odm/media/scene/ >/dev/null 2>&1
#    chmod 755 /odm/media/scene/

#    rm -rf /odm/media/scene/ZY-VIDEO-1.*
#    rm -rf /odm/media/scene/ZY-VIDEO-3.*
#    rm -rf /odm/media/scene/ZY-VIDEO-6.*

#    copyFile $preInstallDir/Media/ZY-VIDEO-2.mov /odm/media/scene/ZY-VIDEO-2.mov
#    copyFile $preInstallDir/Media/ZY-VIDEO-4.mov /odm/media/scene/ZY-VIDEO-4.mov
#    copyFile $preInstallDir/Media/ZY-VIDEO-5.mov /odm/media/scene/ZY-VIDEO-5.mov

#    chmod 644 /odm/media/scene/*.mov
#  else
    mkdir -p /system/media/scene/ >/dev/null 2>&1
    chmod 755 /system/media/scene/
    
    if [ ! -e "$preInstallDir/Media" ]; then
        return
    fi
    
    rm -rf /system/media/scene/ZY-VIDEO-1.*
    rm -rf /system/media/scene/ZY-VIDEO-3.*
    rm -rf /system/media/scene/ZY-VIDEO-6.*

    copyFile $preInstallDir/Media/ZY-VIDEO-2.mov /system/media/scene/ZY-VIDEO-2.mov
    copyFile $preInstallDir/Media/ZY-VIDEO-4.mov /system/media/scene/ZY-VIDEO-4.mov
    copyFile $preInstallDir/Media/ZY-VIDEO-5.mov /system/media/scene/ZY-VIDEO-5.mov

    chmod 644 /system/media/scene/*.mov
#  fi
}

function copyMusicToSdcard()
{
  copyFile $preInstallDir/Media/SONG1.mp3  "/sdcard/SONG1.mp3"
  copyFile $preInstallDir/Media/SONG2.mp3  "/sdcard/SONG2.mp3"

  mkdir -p /system/media/audio/music >/dev/null 2>&1
  chmod 755 /system/media/audio/music
  copyFile $preInstallDir/Media/SONG1.mp3  "/system/media/audio/music/SONG1.mp3"
  copyFile $preInstallDir/Media/SONG2.mp3  "/system/media/audio/music/SONG2.mp3"
  chmod 644 /system/media/audio/music/*.*
}

function removeMusicFromSdcard()
{
  rm -rf /sdcard/SONG1.mp3
  rm -rf /sdcard/SONG2.mp3
  rm -rf /system/media/audio/music/*.*
  rm -rf /odm/media/audio/music/*.*
}

function settingSystemCommon()
{
  echo "${str_change_setting}"
  settings put global auto_time 1
  settings put global auto_time_zone 1
  settings put system time_12_24 24
  settings put system sound_effects_enabled 0      #触摸提示音
  settings put system lockscreen_sounds_enabled 0  #锁屏提示音
  settings put system volume_ring_speaker 0  #铃声和通知音量
  settings put system volume_alarm_speaker 0  #闹钟音量
  
  [ "$(settings get secure doze_enabled)" == "1" ] && settings put secure doze_enabled 0
  setprop persist.adb.tcp.port 0
  #height=`getprop persist.custom.navbar.height`
  #[ "$height" != "" ] && rm -rf /data/property/persist.custom.navbar.height

  #pm disable com.android.music >/dev/null 2>&1
  pm disable com.android.gallery3d >/dev/null 2>&1
  pm disable com.google.android.apps.plus >/dev/null 2>&1

  if [ $sdk -gt 23 ]; then
    pm grant com.android.apkinstaller android.permission.WRITE_EXTERNAL_STORAGE
    pm grant com.android.apkinstaller android.permission.READ_EXTERNAL_STORAGE

    #pm grant android.rk.RockVideoPlayer android.permission.WRITE_EXTERNAL_STORAGE
    #pm grant android.rk.RockVideoPlayer android.permission.READ_EXTERNAL_STORAGE

    pm path com.android.providers.contacts >/dev/null 2>&1
    if [ $? != 0 ]; then
      #没有联系人存储就禁用谷歌注音输入法的通讯录权限
      pm revoke com.google.android.apps.inputmethod.zhuyin android.permission.GET_ACCOUNTS
      pm revoke com.google.android.apps.inputmethod.zhuyin android.permission.READ_CONTACTS
    fi
  fi

  if [ $sdk -ge 26 ]; then
    grep persist.sys.disable_rescue /system/build.prop >/dev/null 2>&1
    if [ $? != 0 ]; then
      echo "persist.sys.disable_rescue=true" >> /system/build.prop
    fi
  fi

  settings put secure user_setup_complete 1
  settings put global device_provisioned 1

  #禁止弹出通知
  appops set com.facebook.katana POST_NOTIFICATION ignore >/dev/null 2>&1
  appops set com.ss.android.article.news POST_NOTIFICATION ignore >/dev/null 2>&1
  appops set com.baidu.searchbox POST_NOTIFICATION ignore >/dev/null 2>&1
  appops set com.tencent.mtt POST_NOTIFICATION ignore >/dev/null 2>&1
  appops set com.qiyi.video.pad POST_NOTIFICATION ignore >/dev/null 2>&1
  [ $sdk -ge 24 ] && appops write-settings >/dev/null 2>&1
  
  if [ "$build_user" == "sunshine" ] && [ "$sdk" == "28" ]; then
    if [ ! -e /system/bin/supersu ] && [ -e /vender/bin/supersu ]; then
        cp -rf /vender/bin/supersu /system/bin/supersu
        chown root:shell /system/bin/supersu
        chmod 6755 /system/bin/supersu
    fi
  fi
}

function switchInputMethod()
{
    if [ $sdk -gt 19 ]; then
      pm enable com.google.android.inputmethod.pinyin >/dev/null 2>&1
      #pm disable com.android.inputmethod.pinyin >/dev/null 2>&1
    else
      pm enable com.android.inputmethod.pinyin >/dev/null 2>&1
      #pm disable com.google.android.inputmethod.pinyin >/dev/null 2>&1
    fi

    pm enable com.android.inputmethod.latin >/dev/null 2>&1
    pm enable jp.co.omronsoft.openwnn >/dev/null 2>&1
    pm enable com.google.android.apps.inputmethod.zhuyin >/dev/null 2>&1
    
    if [ "$language" == "zh_CN" ]; then
      echo "${str_switch_pinyin}"
      if [ $sdk -gt 19 ]; then
        ime enable com.google.android.inputmethod.pinyin/.PinyinIME >/dev/null 2>&1
        ime set com.google.android.inputmethod.pinyin/.PinyinIME >/dev/null 2>&1
      else
        ime enable com.android.inputmethod.pinyin/.PinyinIME >/dev/null 2>&1
        ime set com.android.inputmethod.pinyin/.PinyinIME >/dev/null 2>&1
      fi
      #ime disable jp.co.omronsoft.openwnn/.OpenWnnJAJP >/dev/null 2>&1
      #ime disable com.google.android.apps.inputmethod.zhuyin/.ZhuyinInputMethodService >/dev/null 2>&1
    elif [ "$language" == "zh_TW" ]; then
      echo "${str_switch_zhuyin}"
      ime enable com.google.android.apps.inputmethod.zhuyin/.ZhuyinInputMethodService >/dev/null 2>&1
      ime set com.google.android.apps.inputmethod.zhuyin/.ZhuyinInputMethodService >/dev/null 2>&1
      
      #ime disable com.google.android.inputmethod.pinyin/.PinyinIME >/dev/null 2>&1
      #ime disable com.android.inputmethod.pinyin/.PinyinIME >/dev/null 2>&1
      #ime disable jp.co.omronsoft.openwnn/.OpenWnnJAJP >/dev/null 2>&1
      #ime disable com.android.inputmethod.latin/.LatinIME >/dev/null 2>&1
    elif [[ "$language" == "ja"* ]]; then
      echo "${str_switch_jp}"
      ime enable jp.co.omronsoft.openwnn/.OpenWnnJAJP >/dev/null 2>&1
      ime set jp.co.omronsoft.openwnn/.OpenWnnJAJP >/dev/null 2>&1
      
      #ime disable com.google.android.inputmethod.pinyin/.PinyinIME >/dev/null 2>&1
      #ime disable com.android.inputmethod.pinyin/.PinyinIME >/dev/null 2>&1
      #ime disable com.google.android.apps.inputmethod.zhuyin/.ZhuyinInputMethodService >/dev/null 2>&1
      #ime disable com.android.inputmethod.latin/.LatinIME >/dev/null 2>&1
    else
      echo "${str_switch_latin}"
      ime enable com.android.inputmethod.latin/.LatinIME >/dev/null 2>&1
      ime set com.android.inputmethod.latin/.LatinIME >/dev/null 2>&1
      
      #ime disable com.google.android.inputmethod.pinyin/.PinyinIME >/dev/null 2>&1
      #ime disable com.android.inputmethod.pinyin/.PinyinIME >/dev/null 2>&1
      #ime disable jp.co.omronsoft.openwnn/.OpenWnnJAJP >/dev/null 2>&1
      #ime disable com.google.android.apps.inputmethod.zhuyin/.ZhuyinInputMethodService >/dev/null 2>&1
    fi
}

function makeInstallRecoveryFile(){
    file_install_recovery="/system/bin/install-recovery.sh"
    if [ ! -e $file_install_recovery ]; then
        result=0
    else
        grep "version=2.0" $file_install_recovery >/dev/null 2>&1
        result=$?    
    fi
    
    if [ "$result" == "1" ]; then
        cat >"${file_install_recovery}" <<"EOF"    
#!/system/bin/sh
#version=2.0

list=$(ls /system/bin/run/*.sh 2>/dev/null)

for script in $list; do
    sh "$script" &
done
EOF
        chmod 755 /system/bin/install-recovery.sh
        mkdir /system/bin/run >/dev/null 2>&1
        chmod 755 /system/bin/run
    fi
}

function makeService(){
    file_rc="/vendor/etc/init/hw/init.rk3399.rc"
    if [ ! -e $file_rc ]; then
        return
    fi 
    
    grep removelock.sh $file_rc >/dev/null 2>&1
    if [ $? == 0 ]; then
        return
    fi
    
    mount -o rw,remount /vendor >/dev/null 2>&1
    rm -rf /vendor/bin/awk
    cat >>"${file_rc}" <<"EOF"
service removelock /system/bin/run/removelock.sh
    class core
    group root
    user root
    seclabel u:r:shell:s0
    oneshot
    
EOF

}

function installWipeData()
{
    if [ ! -e $preInstallDir/wipedata/wipedata.sh ]; then
        return
    fi
 
    makeInstallRecoveryFile
    
    #rm -rf /system/bin/wipedata.sh
     
    version1=`grep \#ver $preInstallDir/wipedata/wipedata.sh`
    version2=`grep \#ver /system/bin/run/wipedata.sh`
    if [ "$version1" != "$version2" ]; then
      cp -rf $preInstallDir/wipedata/wipedata.sh /system/bin/run/wipedata.sh
      cp -rf $preInstallDir/wipedata/wipedata.sh /system/bin/wipedata.sh
      chmod 755 /system/bin/run/wipedata.sh
      echo 更新开机异常修复功能完成
      sleep 2
    fi 
}

function installpreInstall()
{
    if [ "$folder_preinstall" != "/system/preInstall" ]; then
        return
    fi
    
    if [ ! -e $preInstallDir/preinstall.sh ]; then
        return
    fi
    
    local busybox_meefik="$preInstallDir/busybox-meefik_v1.31.1"
    if [ ! -e /system/bin/busybox-meefik ]; then
        cp -rf $busybox_meefik "/system/bin/busybox-meefik"
        chmod 755 "/system/bin/busybox-meefik"
    fi
     
    makeInstallRecoveryFile
    
    #rm -rf /system/bin/preinstall.sh
     
    version1=`grep \#ver $preInstallDir/preinstall.sh`
    version2=`grep \#ver /system/bin/run/preinstall.sh`
        
    if [ "$version1" != "$version2" ]; then
      cp -rf $preInstallDir/preinstall.sh /system/bin/run/preinstall.sh
      cp -rf $preInstallDir/preinstall.sh /system/bin/preinstall.sh
      chmod 755 /system/bin/run/preinstall.sh
      setprop persist.custom.preinstalled 1
      echo 更新自动安装应用脚本完成
      sleep 2
    fi   
}

function installRemoveLock()
{
    if [ ! -e $preInstallDir/wipedata/removelock.sh ]; then
        return
    fi
 
    if [ $sdk -lt 26 ]; then
        return
    fi
    
    makeInstallRecoveryFile
    makeService
    
    mkdir /system/bin/run >/dev/null 2>&1
    chmod 755 /system/bin/run
     
    version1=`grep \#ver $preInstallDir/wipedata/removelock.sh`
    version2=`grep \#ver /system/bin/run/removelock.sh`
    if [ "$version1" != "$version2" ]; then
      cp -rf $preInstallDir/wipedata/removelock.sh /system/bin/run/removelock.sh
      chmod 755 /system/bin/run/removelock.sh
      echo 更新去除锁屏密码功能完成
      sleep 2
    fi 
}

function removeSpaxfiles()
{
    local result=`isExistApp com.onespax.launcher`
    if [ "$result" == "0" ]; then
      return
    fi
    
    if [ -e /system/etc/system_fonts.xml_bak ]; then
      cp -rf /system/etc/system_fonts.xml_bak /system/etc/system_fonts.xml
      rm -rf /system/etc/system_fonts.xml_bak
    fi
    
    if [ -e /system/etc/fallback_fonts.xml_bak ]; then
      cp -rf /system/etc/fallback_fonts.xml_bak /system/etc/fallback_fonts.xml
      rm -rf /system/etc/fallback_fonts.xml_bak
    fi
    
    rm -rf /system/media/video
    rm -rf /sdcard/test.mp3
    rm -rf /system/fonts/Futura_LT_*.*
    rm -rf /system/fonts/NotoSansCJKsc-*.*
    
    pm uninstall com.onespax.launcher >/dev/null 2>&1
    pm uninstall com.frp.fun >/dev/null 2>&1
    
    rm -rf /system/preinstall/com.onespax.launcher* >/dev/null 2>&1
    rm -rf /system/preInstall/com.onespax.launcher* >/dev/null 2>&1
}

function removeSu()
{
    if [ "$build_user" == "sunshine" ]; then
        path_su=$(busybox which su)
        if [ ! -e /system/bin/supersu ]; then
          cp -rf ${path_su} /system/bin/supersu
          chown root:shell /system/bin/supersu
          chmod 6755 /system/bin/supersu
        fi
        if [ -e /system/bin/supersu ]; then
            rm -rf ${path_su}
            rm -rf /system/bin/su
            rm -rf /system/xbin/su
            rm -rf /vendor/xbin/su
        fi
    else
        list=$(busybox ps)
        echo "$list" | grep "daemonsu:master" >/dev/null 2>&1
        result=$?
        if [ $result == 0 ]; then
            echo "$list" | grep "{su} daemonsu:master" >/dev/null 2>&1
            result=$?
            if [ $result != 0 ]; then
                path_su=$(busybox which su)
                if [ ! -e /system/bin/supersu ]; then
                  cp -rf ${path_su} /system/bin/supersu
                  chown root:shell /system/bin/supersu
                  chmod 755 /system/bin/supersu
                fi
                if [ -e /system/bin/supersu ]; then
                    rm -rf ${path_su}
                    rm -rf /system/bin/su
                    rm -rf /system/xbin/su
                    rm -rf /vendor/xbin/su
                fi
            fi
        fi
    fi
}

function changeLogo()
{
    logo=$1
    [ "$logo" == "" ] && return
    logo=$(busybox tr '[a-z]' '[A-Z]' <<< "$logo")
    screensize=`wm size | busybox awk -F ': ' '{print $2}'`
    logofile=logo_${logo}_${screensize}
    logopath=$preInstallDir/${logofile}.zip

    if [ -e "${logopath}" ]; then
        echo "${str_change_logo}"
        cp -rf "${logopath}" /system/media/bootanimation.zip
        sync
        chmod 666 /system/media/bootanimation.zip
        sleep 3
    else
        echo "${str_not_exist} ${logofile}"
        sleep 6
    fi
}

function patch3399()
{
    if [ "$sdk" == "29" ]; then
        grep "sdcard_rw" /system/etc/permissions/platform.xml >/dev/null 2>&1
        if [ $? != 0 ]; then
            mountSystem
            cp -rf $preInstallDir/systemapp/platform_rk3399.xml /system/etc/permissions/platform.xml
            chmod 644 /system/etc/permissions/platform.xml
        fi
    fi
}

function makeSerialno()
{
    FILE_SERIAL=/system/etc/serialno

    if [ ! -e /sys/class/net/wlan0/address ]; then
        svc wifi enable
        sleep 2    
    fi

    if [ -e /sys/class/net/wlan0/address ]; then
        mac=$(cat /sys/class/net/wlan0/address)
    else
        return    
    fi
    
    #echo "mac=${mac}"
    serial="$(echo ${mac//[:-]} | busybox tr '0123456789ABCDEFabcdef' 'ABCDEFGHIJKLMNOPKLMNOP')"
    #echo "serial=${serial}"
    
    mountSystem
    echo $serial > $FILE_SERIAL
    chmod 644 $FILE_SERIAL
}
mountSystem
makeSerialno

installRemoveLock

patch3399
