#!/system/bin/sh
#2021-04-26
forceLang="EN"

str_start="开始安装阿迪达斯"
str_not_exsist_common_file="不存在install_common.sh"
if [ "$forceLang" == "EN" ]; then
  str_start="start installing..."
  str_not_exsist_common_file="not exist install_common.sh file"
fi

echo "${str_start}"
basedir=/mnt/usb_storage/preInstall
if [ ! -e $basedir ]; then
  if [ "${USB_STORAGE}" == "" ]; then
    USB_STORAGE=/storage/$(ls /storage | grep ".*-.*")
  fi
  basedir=${USB_STORAGE}/preInstall
fi

if [ -e $basedir/install_common.sh ]; then
  source $basedir/install_common.sh
else
  echo "${str_not_exsist_common_file}"
  sleep 3600
  exit
fi

######################################################
######################################################
function settingSystemUser()
{
    height=`getprop persist.custom.navbar.height`
    [ "$height" != "" ] && rm -rf /data/property/persist.custom.navbar.height

    pm disable com.android.music >/dev/null 2>&1
    pm disable com.android.gallery3d >/dev/null 2>&1
    pm disable com.google.android.apps.plus >/dev/null 2>&1
}

function uninstallThirdApp()
{
#需要保留的app列表
  local appList="
	com.baidu.searchbox
	com.elinkway.tvlive2
	com.dianshijia.newlive
	com.hpplay.happyplay.aw
	com.tencent.qqmusicpad
	com.google.android.youtube
	com.twitter.android
	com.android.chrome
	com.netflix.mediaclient
	com.facebook.katana
	com.spotify.music
	com.amazon.avod.thirdpartyclient
	com.actionsmicro.ezscreen
	com.zhongyang.treadmill
	com.zhongyang.autoinstall
	com.android.vending
	com.google.android.inputmethod.pinyin
	com.android.inputmethod.pinyin
	com.google.android.gms
	com.google.android.gsf
	com.google.android.apps.inputmethod.zhuyin"

  local currentAppList=`pm list packages -3 | busybox awk -F ':' '{print $2}'`
  for i in $currentAppList; do
    echo $appList | grep $i >/dev/null 2>&1
    if [ $? != 0 ]; then
      echo "${str_uninstall} ${i}"
      pm uninstall $i >/dev/null 2>&1
      rm -rf /system/preinstall/$i*
    fi
  done
}

###################################################
###################################################
am start -n com.android.rk/.RockExplorer >/dev/null 2>&1

mountSystem

checkSpace

if [ "$opt_canCopyVideo" == "0" ]; then
  rm -rf /system/media/scene/*.*
fi
rm -rf /sdcard/operationbook.mp4 >/dev/null 2>&1

readTreadmillConfig

opt_canCopyCnApp=-1
opt_canCopyEnApp=-1
if [ $opt_canCopyVideo == 1 -a $opt_canCopyApp == 0 ]; then
   [ "$config_Lang" == "" ] && config_Lang="zh_CN"
   
  if [ "$config_Lang" != "zh_CN" ]; then
    opt_canCopyEnApp=1
    opt_canCopyCnApp=0
  else
    opt_canCopyEnApp=0
    opt_canCopyCnApp=1  
  fi
fi

if [ "$opt_canCopyApp" == "1" ]; then
  opt_canCopyCnApp=1
  opt_canCopyEnApp=1
fi

if [ "$opt_canCopyCnApp" == "0" ]; then
    rm -rf /system/preinstall/com.tencent.qqmusicpad*
    rm -rf /system/preinstall/com.elinkway.tvlive2*
    rm -rf /system/preinstall/com.dianshijia.newlive*
    rm -rf /system/preinstall/com.hpplay.happyplay.aw*
    rm -rf /system/preinstall/com.tencent.qqmusicpad*
fi

if [ "$opt_canCopyEnApp" == "0" ]; then
    rm -rf /system/preinstall/com.android.chrome*
    rm -rf /system/preinstall/com.netflix.mediaclient*
    rm -rf /system/preinstall/com.google.android.youtube*
    rm -rf /system/preinstall/com.spotify.music*
    rm -rf /system/preinstall/com.facebook.katana*
    rm -rf /system/preinstall/com.twitter.android*
    rm -rf /system/preinstall/com.amazon.avod.thirdpartyclient*
fi

pm uninstall com.ttpaobu.zhongyang.panelui >/dev/null 2>&1
installTreadmillApp "TM"

uninstallThirdApp

#echo 拷贝动态库文件到系统
copyLibToSystem
copyVlcLibToSystem

removeGoogleAccounts
installGooglePlay
installNewGMS
installPlayStore

installDianShiJia $opt_canCopyCnApp
installLeBo $opt_canCopyCnApp
installBaidu $opt_canCopyCnApp
installQQMusicHD $opt_canCopyCnApp

installYoutube $opt_canCopyEnApp
installChrome $opt_canCopyEnApp
installFacebook $opt_canCopyEnApp
installTwitter $opt_canCopyEnApp
installPrimeVideo $opt_canCopyEnApp
installSpotify $opt_canCopyEnApp
installNetflix $opt_canCopyEnApp


installApkInstaller
installLatin
installPinyin
installZhuyin
installProvision

echo "${str_copy_media}"
copyScene241ToSdcard
if [ "$opt_canCopyVideo" == "1" ]; then
  copyScene241ToSystem
fi
removeMusicFromSdcard


switchInputMethod

settingSystemCommon
settingSystemUser

installAutoinstall


if [ -e $basedir/install_wipedata.sh ]; then
  source $basedir/install_wipedata.sh
fi

sync

if [ -e $basedir/check_ADI.sh ]; then
  source $basedir/check_ADI.sh
fi

echo "${str_ready_reboot}"
sleep 5
rm -rf /data/dalvik-cache/arm/*readmill*.dex
reboot


